/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSSOAPConstants;
import filenet.ws.utils.WSConstants;
import java.io.StringReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class WSDefinitionBuilder {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static final String m_className = "WSDefinitionBuilder";
    static final String s_targetNamespaceURI = "http://www.filenet.com/process/p8-3x/2004";
    static final String s_targetNamespace = "targetNamespace";
    static final String s_xmlnsTNS = "xmlns:tns";
    static final String s_xmlns = "xmlns:";
    static final String s_tns = "tns";
    static final String s_xsd = "xsd";
    static final String s_xsd0 = "xsd0";
    static final String s_mime = "mime";
    static final String s_wsdl = "wsdl";
    static final String s_schema = "schema";
    static final String s_soap = "soap";
    static final String s_wsse = "wsse";
    static final String s_wsa = "wsa";
    static final String s_literal = "literal";
    static final String s_attachments = "attachments";
    static final String s_mimeType = "application/binary";
    static final String s_xmlString = "xmlString";
    static final String s_xmlStringElement = "xmlStringElement";
    static final String s_attachmentRef = "attachmentRef";
    static final String s_attachmentRefElement = "attachmentRefElement";
    static final String s_documentationTagName = "documentation";
    static final String s_wsdlURI = "http://schemas.xmlsoap.org/wsdl/";
    static final String s_xmlnsURI = "http://www.w3.org/2000.xmlns/";
    static final String s_soapHttpTransportURI = "http://schemas.xmlsoap.org/soap/http";
    static final String s_soapEncodingStypeURI = "http://schemas.xmlsoap.org/soap/encoding";
    static final String s_appinfo = "appinfo";
    static final String s_fnpeTag = "fnpe";
    static final String s_validateUsingSchemaAttribute = "validateUsingSchema";
    static final String s_validateUsingSchema = "1";
    static final String s_predefined = "Predefined";
    static final String s_replyHeader = "ReplyHeader";
    static final String s_securityHeader = "SecurityHeader";
    static final String s_processPartName = "fields";
    static final String s_processField = "ProcessField";
    static final String s_processAttachmentPartName = "attachment";
    static final String s_processAttachment = "ProcessAttachment";
    static final String s_processType = "processType";
    static final String s_type = "Type";
    static final String s_element = "Element";
    public static final String s_xmlStringTypeName = "xmlString";
    public static final String s_attachmentByValueTypeName = "attachment";
    public static final String s_attachmentByRefTypeName = "attachmentRef";
    public static final String s_version0 = "Version0";
    public static final String s_attachmentByRefTypeNameVersion0 = "attachmentRefVersion0";
    public static final String s_xmlStringTypeNameVersion0 = "xmlStringVersion0";
    private String m_productInfoString = null;
    private Definition m_definition = null;
    private WSDLFactory m_wsdlFactory = null;
    private String m_definitionTNS = null;
    private WSDefinition m_wsDefinition = null;
    private Hashtable m_schemas = new Hashtable();
    private Hashtable m_portTypes = new Hashtable();
    private Hashtable m_operations = new Hashtable();
    private Hashtable m_messages = new Hashtable();
    private Hashtable m_msssageOrderedParts = new Hashtable();
    private static Hashtable m_classNames = new Hashtable();
    private PredefinedSchema m_predefinedSchema = null;
    private Document m_doc = null;
    private WSConstants m_wsConstants = null;

    public static String _get_FILE_DATE() {
        return "$Date:   18 Oct 2008 18:01:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.49  $";
    }

    public void releaseReferences() {
        block9: {
            try {
                this.m_productInfoString = null;
                this.m_definition = null;
                this.m_wsdlFactory = null;
                this.m_definitionTNS = null;
                this.m_wsDefinition = null;
                if (this.m_schemas != null) {
                    Hashtable schemas = this.m_schemas;
                    this.m_schemas = null;
                    Schema schema = null;
                    Enumeration enumValues = schemas.elements();
                    while (enumValues.hasMoreElements()) {
                        schema = (Schema)enumValues.nextElement();
                        if (schema == null) continue;
                        schema.releaseReferences();
                        schema = null;
                    }
                    schemas.clear();
                    schemas = null;
                }
                if (this.m_portTypes != null) {
                    this.m_portTypes.clear();
                    this.m_portTypes = null;
                }
                if (this.m_operations != null) {
                    this.m_operations.clear();
                    this.m_operations = null;
                }
                if (this.m_messages != null) {
                    this.m_messages.clear();
                    this.m_messages = null;
                }
                if (this.m_msssageOrderedParts != null) {
                    this.m_msssageOrderedParts.clear();
                    this.m_msssageOrderedParts = null;
                }
                if (this.m_portTypes != null) {
                    this.m_portTypes.clear();
                    this.m_portTypes = null;
                }
                this.m_predefinedSchema = null;
                this.m_doc = null;
                this.m_wsConstants = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block9;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public void releaseWSDefinitionReferences() {
        if (this.m_wsDefinition != null) {
            this.m_wsDefinition.releaseReferences();
            this.m_wsDefinition = null;
        }
    }

    public WSDefinitionBuilder(String name) throws Exception {
        this(name, null, null);
    }

    public WSDefinitionBuilder(String productInfoString, String targetNamespace, String descriptions) throws Exception {
        this(productInfoString, WSConstants.getDefaultWSConstants(), targetNamespace, descriptions);
    }

    public WSDefinitionBuilder(String productInfoString, WSConstants wsConstants, String targetNamespace, String descriptions) throws Exception {
        this.m_wsConstants = wsConstants;
        try {
            this.m_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            this.m_doc = new DocumentImpl();
        }
        this.m_definition = this.createDefinition(productInfoString, targetNamespace, descriptions);
    }

    public void setValidateUsingSchema(boolean bValidate) {
        if (this.m_definition == null || this.m_doc == null || !bValidate) {
            return;
        }
        Element docElt = this.m_definition.getDocumentationElement();
        Element appinfo = null;
        Element fnpe = null;
        if (docElt == null) {
            docElt = this.m_doc.createElement("wsdl:documentation");
            this.m_definition.setDocumentationElement(docElt);
        } else {
            appinfo = WSDefinition.getChildElement(docElt, s_appinfo);
        }
        if (appinfo == null) {
            appinfo = this.m_doc.createElement(s_appinfo);
            docElt.appendChild(appinfo);
        } else {
            fnpe = WSDefinition.getChildElement(appinfo, s_fnpeTag);
        }
        if (fnpe == null) {
            fnpe = this.m_doc.createElement(s_fnpeTag);
            appinfo.appendChild(fnpe);
        }
        if (fnpe != null) {
            fnpe.setAttribute(s_validateUsingSchemaAttribute, s_validateUsingSchema);
        }
    }

    public void addInputMimeAttachments(String bindingName, String operationName) throws Exception {
        Binding binding = this.m_definition.getBinding(new QName(this.m_definitionTNS, bindingName));
        if (binding == null) {
            return;
        }
        BindingOperation bindingOperation = this.getBindingOperation(bindingName, operationName);
        if (bindingOperation == null) {
            return;
        }
        PortType portType = binding.getPortType();
        if (portType == null) {
            return;
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            return;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput == null && operation.getInput() != null) {
            bindingInput = this.addBindingInput(bindingOperation, operation.getInput());
        }
        this.addMimeAttachment(operation.getInput(), bindingInput);
    }

    public Message addMessage(String msgName, String schemaName, String element) throws Exception {
        if (msgName == null || element == null) {
            return null;
        }
        Object obj = this.m_messages.get(msgName);
        if (obj != null && obj instanceof Message) {
            return (Message)obj;
        }
        String s = "addMessage(" + msgName + ", " + schemaName + ", " + element + "):";
        String partPrefix = this.getPartPrefix(msgName);
        Vector<String> orderedParts = new Vector<String>();
        if (schemaName != null) {
            Message msg = this.m_definition.createMessage();
            Part part = this.m_definition.createPart();
            part.setName(partPrefix + "body");
            Schema schema = (Schema)this.m_schemas.get(schemaName);
            QName qName = schema.getElement(element);
            if (qName != null) {
                part.setElementName(qName);
                msg.addPart(part);
                msg.setUndefined(false);
                msg.setQName(new QName(this.m_definitionTNS, msgName));
                this.m_definition.addMessage(msg);
                this.m_messages.put(msgName, msg);
                orderedParts.add(part.getName());
                if (orderedParts != null && orderedParts.size() > 0) {
                    this.m_msssageOrderedParts.put(msgName, orderedParts);
                }
                return msg;
            }
            Object[] arguments = new String[]{msgName, schemaName, element, element};
            throw new VWException("filenet.ws.api.unableToFindSchemaElement", "addMessage({0}, {1}, {2}): Unable to find schema elemetn - {3}", arguments);
        }
        QName qName = this.getBaseTypeElement(element);
        if (element == null) {
            Object[] arguments = new String[4];
            arguments[0] = msgName;
            arguments[1] = schemaName;
            arguments[2] = element;
            throw new VWException("filenet.ws.api.requireNonBaseTypeMEssage", "addMessage({0}, {1}, {2}): schema required for non-base type message", arguments);
        }
        Message msg = this.m_definition.createMessage();
        Part part = this.m_definition.createPart();
        part.setName(partPrefix + "body");
        part.setElementName(qName);
        msg.addPart(part);
        msg.setUndefined(false);
        msg.setQName(new QName(this.m_definitionTNS, msgName));
        this.m_definition.addMessage(msg);
        this.m_messages.put(msgName, msg);
        orderedParts.add(part.getName());
        if (orderedParts != null && orderedParts.size() > 0) {
            this.m_msssageOrderedParts.put(msgName, orderedParts);
        }
        return msg;
    }

    public void addMessage(String msgName, Vector simpleParameters, Vector attachmentParameters) throws Exception {
        QName[] elements;
        if (msgName == null || simpleParameters == null && attachmentParameters == null) {
            return;
        }
        String s = "addMessage(" + msgName + ", fields ):";
        this.addPredefinedSchema();
        Message msg = null;
        QName fieldElement = null;
        Object attachElements = null;
        Vector<String> orderedParts = new Vector<String>();
        String partPrefix = this.getPartPrefix(msgName);
        if (simpleParameters != null && simpleParameters.size() > 0 && (fieldElement = this.getPredefinedSchema().getElement(msgName, simpleParameters, false)) != null) {
            if (msg == null) {
                msg = this.m_definition.createMessage();
            }
            Part part = this.m_definition.createPart();
            part.setName(partPrefix + s_processPartName);
            part.setElementName(fieldElement);
            msg.addPart(part);
            orderedParts.add(part.getName());
        }
        if (attachmentParameters != null && attachmentParameters.size() > 0 && (elements = this.getPredefinedSchema().getElements(msgName, attachmentParameters, true)) != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                if (msg == null) {
                    msg = this.m_definition.createMessage();
                }
                Part part = this.m_definition.createPart();
                String partName = null;
                partName = i == 0 ? "attachment" : "attachment" + i;
                part.setName(partPrefix + partName);
                part.setElementName(elements[i]);
                msg.addPart(part);
                orderedParts.add(part.getName());
            }
        }
        if (msg != null) {
            msg.setUndefined(false);
            msg.setQName(new QName(this.m_definitionTNS, msgName));
            this.m_definition.addMessage(msg);
            this.m_messages.put(msgName, msg);
            if (orderedParts != null && orderedParts.size() > 0) {
                this.m_msssageOrderedParts.put(msgName, orderedParts);
            }
        }
    }

    private void addPredefinedSchema() {
        String m_method = "addPredefinedSchema";
        if (this.m_schemas.get(s_predefined) == null) {
            try {
                this.m_schemas.put(s_predefined, new Schema(s_predefined, this.m_wsConstants.P8BPM_PREDEFINED_SCHEMA, true));
            }
            catch (Exception ex) {
                logger.throwing(m_className, "addPredefinedSchema", ex);
            }
        }
    }

    private String getPartPrefix(String msgName) {
        String prefix = new String();
        if (msgName != null) {
            int input = msgName.lastIndexOf("Input");
            int output = msgName.lastIndexOf("Output");
            if (input != -1 || output == -1) {
                prefix = input > output ? new String("in") : new String("out");
            }
        }
        return prefix;
    }

    private boolean anyAttachmentParameter(Vector params) {
        if (params == null || params.size() == 0) {
            return false;
        }
        Object obj = null;
        Object[] p = null;
        for (int i = 0; i < params.size(); ++i) {
            String type;
            obj = params.get(i);
            if (obj == null || !(obj instanceof Object[]) || (p = (Object[])obj).length < 2 || p[1] == null || !(p[1] instanceof String ? ((type = (String)p[1]).endsWith("[]") ? type.compareTo("attachment[]") == 0 : type.compareTo("attachment") == 0) : p[1] instanceof Vector && this.anyAttachmentParameter((Vector)p[1]))) continue;
            return true;
        }
        return false;
    }

    public void addEmptyMessage(String msgName) throws Exception {
        if (msgName == null) {
            return;
        }
        String s = "addEmptyMessage(" + msgName + "):";
        Message msg = null;
        msg = this.m_definition.createMessage();
        if (msg != null) {
            msg.setUndefined(false);
            msg.setQName(new QName(this.m_definitionTNS, msgName));
            this.m_definition.addMessage(msg);
            this.m_messages.put(msgName, msg);
        }
    }

    public void addMessage(String msgName, Vector wsParams) throws Exception {
        if (msgName == null || wsParams == null || wsParams.size() == 0) {
            return;
        }
        String s = "addMessage(" + msgName + ", parameters ):";
        this.addPredefinedSchema();
        Message msg = null;
        QName element = null;
        Object obj = null;
        Object[] p = null;
        String name = null;
        Object type = null;
        String partName = null;
        Vector parameters = null;
        Vector<String> orderedParts = new Vector<String>();
        String partPrefix = this.getPartPrefix(msgName);
        for (int i = 0; i < wsParams.size(); ++i) {
            obj = wsParams.get(i);
            if (obj == null || !(obj instanceof Object[]) || (p = (Object[])obj).length != 2 || p[0] == null || !(p[0] instanceof String)) continue;
            name = (String)p[0];
            if (p[1] == null || !(p[1] instanceof Vector)) continue;
            parameters = (Vector)p[1];
            element = this.getPredefinedSchema().getElement(name, parameters);
            if (msg == null) {
                msg = this.m_definition.createMessage();
            }
            Part part = this.m_definition.createPart();
            partName = this.anyAttachmentParameter(parameters) ? "attachment" : s_processPartName;
            if (i > 0) {
                partName = partName + i;
            }
            part.setName(partPrefix + partName);
            part.setElementName(element);
            msg.addPart(part);
            orderedParts.add(part.getName());
        }
        if (msg != null) {
            msg.setUndefined(false);
            msg.setQName(new QName(this.m_definitionTNS, msgName));
            this.m_definition.addMessage(msg);
            this.m_messages.put(msgName, msg);
            if (orderedParts != null && orderedParts.size() > 0) {
                this.m_msssageOrderedParts.put(msgName, orderedParts);
            }
        }
    }

    public void addOperation(String portTypeName, String operationName, String inputMessageName, String outputMessageName, String opInfo) throws Exception {
        String s = "addOperation(" + portTypeName + ", " + operationName + ", " + inputMessageName + ", " + outputMessageName + "): ";
        if (portTypeName == null || operationName == null) {
            Object[] arguments = new String[]{portTypeName, operationName, inputMessageName, outputMessageName};
            throw new VWException("filenet.ws.api.missingPortTypeOrOperationName", "addOperation({0}, {1}, {2}, {3}) : missing portType name or operation name", arguments);
        }
        PortType portType = this.getPortType(portTypeName);
        if (portType == null) {
            portType = this.addPortType(portTypeName, null);
        }
        Message inputMessage = null;
        Message outputMessage = null;
        Operation operation = null;
        Input input = null;
        Output output = null;
        Vector orderedParts = new Vector();
        if (inputMessageName != null) {
            inputMessage = (Message)this.m_messages.get(inputMessageName);
            Object obj = this.m_msssageOrderedParts.get(inputMessageName);
            if (obj != null && obj instanceof Vector) {
                orderedParts.addAll((Vector)obj);
            }
        }
        if (outputMessageName != null) {
            outputMessage = (Message)this.m_messages.get(outputMessageName);
        }
        if ((operation = (Operation)this.m_operations.get(operationName)) == null) {
            operation = this.m_definition.createOperation();
            operation.setName(operationName);
            operation.setParameterOrdering(orderedParts);
            if (inputMessage != null) {
                input = this.m_definition.createInput();
                input.setMessage(inputMessage);
                operation.setInput(input);
            }
            if (outputMessage != null) {
                output = this.m_definition.createOutput();
                output.setMessage(outputMessage);
                operation.setOutput(output);
            }
            operation.setUndefined(false);
            portType.addOperation(operation);
            this.m_operations.put(operationName, operation);
        } else {
            Object[] arguments;
            if (inputMessage != null) {
                input = operation.getInput();
                if (input == null) {
                    input = this.m_definition.createInput();
                    input.setMessage(inputMessage);
                    operation.setInput(input);
                } else if (!input.getMessage().getQName().equals(inputMessage.getQName())) {
                    arguments = new String[]{portTypeName, operationName, inputMessageName, outputMessageName, input.getMessage().getQName().toString(), inputMessage.getQName().toString()};
                    throw new VWException("filenet.ws.api.sameOperationWithDifferentInputMessages", "addOperation({0}, {1}, {2}, {3}):\nSame operation with different input messages: {4} and {5}", arguments);
                }
            }
            if (outputMessage != null) {
                output = operation.getOutput();
                if (output == null) {
                    output = this.m_definition.createOutput();
                    output.setMessage(outputMessage);
                    operation.setOutput(output);
                } else if (!output.getMessage().getQName().equals(outputMessage.getQName())) {
                    arguments = new String[]{portTypeName, operationName, inputMessageName, outputMessageName, output.getMessage().getQName().toString(), outputMessage.getQName().toString()};
                    throw new VWException("filenet.ws.api.sameOperationWithDifferentInputMessages", "addOperation({0}, {1}, {2}, {3}):\nSame operation with different input messages: {4} and {5}", arguments);
                }
            }
        }
        if (operation != null) {
            Binding[] bindings;
            if (opInfo != null) {
                operation.setDocumentationElement(this.createDescriptionElement(opInfo));
            }
            if ((bindings = this.getBindings(portTypeName)) != null && bindings.length > 0) {
                Binding binding = null;
                for (int i = 0; i < bindings.length; ++i) {
                    binding = bindings[i];
                    if (binding == null) continue;
                    this.addBindingOperation(binding, operation, null);
                }
            }
        }
    }

    public void addOperationFault(String portTypeName, String operationName, String faultName, String faultMessage) throws Exception {
        String s = "addOperationFault(" + portTypeName + ", " + operationName + ", " + faultName + ", " + faultMessage + ": ";
        Object[] arguments = new String[]{portTypeName, operationName, faultName, faultMessage};
        if (portTypeName == null || operationName == null || faultName == null || faultMessage == null) {
            throw new VWException("filenet.ws.api.missingPortType", "addOperationFault({0}, {1}, {2}, {3}): missing prot type", arguments);
        }
        if (operationName == null) {
            throw new VWException("filenet.ws.api.missingOperationName", "addOperationFault({0}, {1}, {2}, {3}): missing operation name", arguments);
        }
        if (faultName == null) {
            throw new VWException("filenet.ws.api.missingFaultName", "addOperationFault({0}, {1}, {2}, {3}): missing fault name", arguments);
        }
        if (faultMessage == null) {
            throw new VWException("filenet.ws.api.missingFaultMessageName", "addOperationFault({0}, {1}, {2}, {3}): missing fault message name", arguments);
        }
        arguments = new String[5];
        arguments[0] = portTypeName;
        arguments[1] = operationName;
        arguments[2] = faultName;
        arguments[3] = faultMessage;
        PortType portType = (PortType)this.m_portTypes.get(portTypeName);
        if (portType == null) {
            arguments[4] = portTypeName;
            throw new VWException("filenet.ws.api.portTypeNotDefined", "addOperationFault({0}, {1}, {2}, {3}): protType {4} not defined", arguments);
        }
        Message message = (Message)this.m_messages.get(faultMessage);
        if (message == null) {
            arguments[4] = faultMessage;
            throw new VWException("filenet.ws.api.faultMessageNotDefined", "addOperationFault({0}, {1}, {2}, {3}): fault message {4} not defined", arguments);
        }
        Operation op = portType.getOperation(operationName, null, null);
        if (op == null) {
            arguments[4] = operationName;
            throw new VWException("filenet.ws.api.operationNotDefined", "addOperationFault({0}, {1}, {2}, {3}): operation {4} not defined", arguments);
        }
        Fault fault = op.getFault(faultName);
        if (fault == null) {
            fault = this.m_definition.createFault();
            fault.setName(faultName);
            fault.setMessage(message);
            op.addFault(fault);
        } else {
            Message msg = fault.getMessage();
            if (msg == null) {
                fault.setMessage(message);
            } else {
                QName msgQName = msg.getQName();
                if (msgQName == null) {
                    fault.setMessage(message);
                } else if (!msgQName.equals(message.getQName())) {
                    arguments[4] = msgQName.toString();
                    throw new VWException("filenet.ws.api.sameFaultWithDifferentMessage", "addOperationFault({0}, {1}, {2}, {3}): same fault was defined with different message - {4}", arguments);
                }
            }
        }
    }

    public void addOutputMimeAttachments(String bindingName, String operationName) throws Exception {
        Binding binding = this.m_definition.getBinding(new QName(this.m_definitionTNS, bindingName));
        if (binding == null) {
            return;
        }
        BindingOperation bindingOperation = this.getBindingOperation(bindingName, operationName);
        if (bindingOperation == null) {
            return;
        }
        PortType portType = binding.getPortType();
        if (portType == null) {
            return;
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            return;
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput == null && operation.getOutput() != null) {
            bindingOutput = this.addBindingOutput(bindingOperation, operation.getOutput());
        }
        this.addMimeAttachment(operation.getOutput(), bindingOutput);
    }

    public Port addPort(String serviceName, String portName, String bindingName, String soapAddress, String description) throws Exception {
        String s = "addPort(" + serviceName + ", " + portName + ", " + bindingName + ", " + soapAddress + ", " + description + "): ";
        Object[] arguments = new String[]{serviceName, portName, bindingName, soapAddress, description};
        if (portName == null || serviceName == null || bindingName == null || soapAddress == null) {
            throw new VWException("filenet.ws.api.missingServicePortBindingOrSoapAddress", "addPort({0}, {1}, {2}, {3}, {4}): service name, port name, binding name, or soapAddress is null", arguments);
        }
        Service service = this.addService(serviceName, null);
        if (service == null) {
            throw new VWException("filenet.ws.api.faileToAddService", "addPort({0}, {1}, {2}, {3}, {4}): failed to add service", arguments);
        }
        Port port = service.getPort(portName);
        if (port == null) {
            port = this.m_definition.createPort();
            port.setName(portName);
            Binding binding = this.m_definition.getBinding(new QName(this.m_definitionTNS, bindingName));
            if (binding == null) {
                throw new VWException("filenet.ws.api.bindingNotDefined", "addPort({0}, {1}, {2}, {3}, {4}): bindingNotDefined", arguments);
            }
            port.setBinding(binding);
            if (soapAddress != null) {
                SOAPAddress soapAddressImpl = (SOAPAddress)this.m_definition.getExtensionRegistry().createExtension(Port.class, WSSOAPConstants.Q_ELEM_SOAP_ADDRESS);
                soapAddressImpl.setLocationURI(soapAddress);
                port.addExtensibilityElement((ExtensibilityElement)soapAddressImpl);
            }
            service.addPort(port);
        }
        return port;
    }

    public PortType addPortType(String portTypeName, String description) {
        PortType portType = this.getPortType(portTypeName);
        if (portType != null) {
            return portType;
        }
        portType = this.m_definition.createPortType();
        portType.setQName(new QName(this.m_definitionTNS, portTypeName));
        portType.setUndefined(false);
        portType.setDocumentationElement(this.createDescriptionElement(description));
        this.m_definition.addPortType(portType);
        this.m_portTypes.put(portTypeName, portType);
        return portType;
    }

    private MIMEMultipartRelated getMIMEMultipartRelated(List extList) {
        if (extList != null && extList.size() > 0) {
            Object obj = null;
            for (int i = 0; i < extList.size(); ++i) {
                obj = extList.get(i);
                if (obj == null || !(obj instanceof MIMEMultipartRelated)) continue;
                return obj;
            }
        }
        return null;
    }

    private SOAPBody getMIMESoapBody(List extList) {
        if (extList != null && extList.size() > 0) {
            Object obj = null;
            for (int i = 0; i < extList.size(); ++i) {
                MIMEMultipartRelated mimeMultipartRelated;
                List mimeParts;
                obj = extList.get(i);
                if (obj == null || !(obj instanceof MIMEMultipartRelated) || (mimeParts = (mimeMultipartRelated = (MIMEMultipartRelated)obj).getMIMEParts()) == null || mimeParts.size() <= 0) continue;
                for (int j = 0; j < mimeParts.size(); ++j) {
                    MIMEPart mimePart;
                    List extElements;
                    obj = mimeParts.get(j);
                    if (obj == null || !(obj instanceof MIMEPart) || (extElements = (mimePart = (MIMEPart)obj).getExtensibilityElements()) == null || extElements.size() <= 0) continue;
                    for (int k = 0; k < extElements.size(); ++k) {
                        obj = extElements.get(k);
                        if (obj == null || !(obj instanceof SOAPBody)) continue;
                        return obj;
                    }
                }
            }
        }
        return null;
    }

    private MIMEPart getMimePart(List extList, String mimePartName) {
        if (extList != null && extList.size() > 0) {
            Object obj = null;
            for (int i = 0; i < extList.size(); ++i) {
                MIMEMultipartRelated mimeMultipartRelated;
                List mimeParts;
                obj = extList.get(i);
                if (obj == null || !(obj instanceof MIMEMultipartRelated) || (mimeParts = (mimeMultipartRelated = (MIMEMultipartRelated)obj).getMIMEParts()) == null || mimeParts.size() <= 0) continue;
                for (int j = 0; j < mimeParts.size(); ++j) {
                    MIMEPart mimePart;
                    List extElements;
                    obj = mimeParts.get(j);
                    if (obj == null || !(obj instanceof MIMEPart) || (extElements = (mimePart = (MIMEPart)obj).getExtensibilityElements()) == null || extElements.size() <= 0) continue;
                    for (int k = 0; k < extElements.size(); ++k) {
                        MIMEContent mimeContent;
                        String partName;
                        obj = extElements.get(k);
                        if (obj == null || !(obj instanceof MIMEContent) || (partName = (mimeContent = (MIMEContent)obj).getPart()) == null || partName.compareTo(mimePartName) != 0) continue;
                        return mimePart;
                    }
                }
            }
        }
        return null;
    }

    private void addMimeSoapBody(BindingInput bindingInput) throws Exception {
        List list;
        if (this.m_definition.getNamespace("http://schemas.xmlsoap.org/wsdl/mime/") == null) {
            this.m_definition.addNamespace(s_mime, "http://schemas.xmlsoap.org/wsdl/mime/");
        }
        if ((list = bindingInput.getExtensibilityElements()) != null && list.size() > 0) {
            Object obj = null;
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof SOAPBody)) continue;
                list.remove(obj);
            }
        }
        if (this.getMIMESoapBody(list) == null) {
            MIMEPart mimePart = (MIMEPart)this.m_definition.getExtensionRegistry().createExtension(MIMEMultipartRelated.class, WSSOAPConstants.Q_ELEM_MIME_PART);
            SOAPBody soapBody = (SOAPBody)this.m_definition.getExtensionRegistry().createExtension(MIMEPart.class, WSSOAPConstants.Q_ELEM_SOAP_BODY);
            soapBody.setUse(s_literal);
            mimePart.addExtensibilityElement((ExtensibilityElement)soapBody);
            MIMEMultipartRelated mimeMultipartRelated = this.getMIMEMultipartRelated(list);
            if (mimeMultipartRelated == null) {
                mimeMultipartRelated = (MIMEMultipartRelated)this.m_definition.getExtensionRegistry().createExtension(BindingInput.class, WSSOAPConstants.Q_ELEM_MIME_MULTIPART_RELATED);
                bindingInput.addExtensibilityElement((ExtensibilityElement)mimeMultipartRelated);
            }
            mimeMultipartRelated.addMIMEPart(mimePart);
        }
    }

    private void addMimeSoapBody(BindingOutput bindingOutput) throws Exception {
        List list;
        if (this.m_definition.getNamespace("http://schemas.xmlsoap.org/wsdl/mime/") == null) {
            this.m_definition.addNamespace(s_mime, "http://schemas.xmlsoap.org/wsdl/mime/");
        }
        if ((list = bindingOutput.getExtensibilityElements()) != null && list.size() > 0) {
            Object obj = null;
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof SOAPBody)) continue;
                list.remove(obj);
            }
        }
        if (this.getMIMESoapBody(list) == null) {
            MIMEPart mimePart = (MIMEPart)this.m_definition.getExtensionRegistry().createExtension(MIMEMultipartRelated.class, WSSOAPConstants.Q_ELEM_MIME_PART);
            SOAPBody soapBody = (SOAPBody)this.m_definition.getExtensionRegistry().createExtension(MIMEPart.class, WSSOAPConstants.Q_ELEM_SOAP_BODY);
            soapBody.setUse(s_literal);
            mimePart.addExtensibilityElement((ExtensibilityElement)soapBody);
            MIMEMultipartRelated mimeMultipartRelated = this.getMIMEMultipartRelated(list);
            if (mimeMultipartRelated == null) {
                mimeMultipartRelated = (MIMEMultipartRelated)this.m_definition.getExtensionRegistry().createExtension(BindingOutput.class, WSSOAPConstants.Q_ELEM_MIME_MULTIPART_RELATED);
                bindingOutput.addExtensibilityElement((ExtensibilityElement)mimeMultipartRelated);
            }
            mimeMultipartRelated.addMIMEPart(mimePart);
        }
    }

    private void addMimeAttachment(Input input, BindingInput bindingInput) throws Exception {
        if (input == null || bindingInput == null) {
            return;
        }
        Map partsMap = input.getMessage().getParts();
        if (partsMap == null || partsMap.isEmpty()) {
            return;
        }
        boolean bMimeBodyAdded = false;
        List list = bindingInput.getExtensibilityElements();
        Collection collection = partsMap.values();
        Iterator it = collection.iterator();
        Object obj = null;
        Part part = null;
        String partName = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null || !(obj instanceof Part) || (partName = (part = (Part)obj).getName()) == null || partName.indexOf("attachment") == -1 || this.getMimePart(list, partName) != null) continue;
            if (!bMimeBodyAdded) {
                if (this.m_definition.getNamespace("http://schemas.xmlsoap.org/wsdl/mime/") == null) {
                    this.m_definition.addNamespace(s_mime, "http://schemas.xmlsoap.org/wsdl/mime/");
                }
                this.addMimeSoapBody(bindingInput);
                bMimeBodyAdded = true;
            }
            MIMEPart mimePart = (MIMEPart)this.m_definition.getExtensionRegistry().createExtension(MIMEMultipartRelated.class, WSSOAPConstants.Q_ELEM_MIME_PART);
            MIMEContent mimeContent = (MIMEContent)this.m_definition.getExtensionRegistry().createExtension(MIMEPart.class, WSSOAPConstants.Q_ELEM_MIME_CONTENT);
            mimeContent.setPart(partName);
            mimeContent.setType(s_mimeType);
            mimePart.addExtensibilityElement((ExtensibilityElement)mimeContent);
            MIMEMultipartRelated mimeMultipartRelated = this.getMIMEMultipartRelated(list);
            if (mimeMultipartRelated == null) {
                mimeMultipartRelated = (MIMEMultipartRelated)this.m_definition.getExtensionRegistry().createExtension(BindingInput.class, WSSOAPConstants.Q_ELEM_MIME_MULTIPART_RELATED);
                bindingInput.addExtensibilityElement((ExtensibilityElement)mimeMultipartRelated);
            }
            mimeMultipartRelated.addMIMEPart(mimePart);
        }
    }

    private void addMimeAttachment(Output output, BindingOutput bindingOutput) throws Exception {
        if (output == null || bindingOutput == null) {
            return;
        }
        Map partsMap = output.getMessage().getParts();
        if (partsMap == null || partsMap.isEmpty()) {
            return;
        }
        boolean bMimeBodyAdded = false;
        List list = bindingOutput.getExtensibilityElements();
        Collection collection = partsMap.values();
        Iterator it = collection.iterator();
        Object obj = null;
        Part part = null;
        String partName = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null || !(obj instanceof Part) || (partName = (part = (Part)obj).getName()) == null || partName.indexOf("attachment") == -1 || this.getMimePart(list, partName) != null) continue;
            if (!bMimeBodyAdded) {
                if (this.m_definition.getNamespace("http://schemas.xmlsoap.org/wsdl/mime/") == null) {
                    this.m_definition.addNamespace(s_mime, "http://schemas.xmlsoap.org/wsdl/mime/");
                }
                this.addMimeSoapBody(bindingOutput);
                bMimeBodyAdded = true;
            }
            MIMEPart mimePart = (MIMEPart)this.m_definition.getExtensionRegistry().createExtension(MIMEMultipartRelated.class, WSSOAPConstants.Q_ELEM_MIME_PART);
            MIMEContent mimeContent = (MIMEContent)this.m_definition.getExtensionRegistry().createExtension(MIMEPart.class, WSSOAPConstants.Q_ELEM_MIME_CONTENT);
            mimeContent.setPart(partName);
            mimeContent.setType(s_mimeType);
            mimePart.addExtensibilityElement((ExtensibilityElement)mimeContent);
            MIMEMultipartRelated mimeMultipartRelated = this.getMIMEMultipartRelated(list);
            if (mimeMultipartRelated == null) {
                mimeMultipartRelated = (MIMEMultipartRelated)this.m_definition.getExtensionRegistry().createExtension(BindingOutput.class, WSSOAPConstants.Q_ELEM_MIME_MULTIPART_RELATED);
                bindingOutput.addExtensibilityElement((ExtensibilityElement)mimeMultipartRelated);
            }
            mimeMultipartRelated.addMIMEPart(mimePart);
        }
    }

    public void addSchema(String schemaName, String xmlSchema) throws Exception {
        if (schemaName == null || schemaName.length() == 0 || xmlSchema == null || xmlSchema.length() == 0) {
            return;
        }
        if (this.m_schemas.containsKey(schemaName)) {
            return;
        }
        Schema schema = new Schema(schemaName, xmlSchema);
        this.m_schemas.put(schemaName, schema);
    }

    public Service addService(String serviceName, String description) throws Exception {
        QName qname = new QName(this.m_definitionTNS, serviceName);
        Service service = this.m_definition.getService(qname);
        if (service == null) {
            service = this.m_definition.createService();
            service.setQName(qname);
            this.m_definition.addService(service);
        }
        if (service != null && description != null && description != null) {
            Element docElt = this.createDescriptionElement(description);
            service.setDocumentationElement(docElt);
        }
        return service;
    }

    public void addSoapAction(String bindingName, String operationName, String soapActionURI) throws Exception {
        if (bindingName == null || operationName == null || soapActionURI == null) {
            return;
        }
        BindingOperation bindingOperation = this.getBindingOperation(bindingName, operationName);
        if (bindingOperation == null) {
            return;
        }
        this.addSoapAction(bindingOperation, soapActionURI);
    }

    private void addSoapAction(BindingOperation bindingOperation, String soapActionURI) throws Exception {
        if (bindingOperation == null || soapActionURI == null) {
            return;
        }
        SOAPOperation soapOperation = null;
        List list = bindingOperation.getExtensibilityElements();
        if (list != null && list.size() > 0) {
            Object obj = null;
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof SOAPOperation)) continue;
                soapOperation = obj;
                break;
            }
        }
        if (soapOperation == null) {
            soapOperation = (SOAPOperation)this.m_definition.getExtensionRegistry().createExtension(BindingOperation.class, WSSOAPConstants.Q_ELEM_SOAP_OPERATION);
            bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
        }
        soapOperation.setSoapActionURI(soapActionURI);
        soapOperation.setStyle("document");
    }

    public Binding getSoapBinding(String bindingName, String portTypeName) {
        if (bindingName == null || portTypeName == null) {
            return null;
        }
        QName qname = new QName(this.m_definitionTNS, bindingName);
        Binding binding = this.m_definition.getBinding(qname);
        return binding;
    }

    public Binding addSoapBinding(String bindingName, String portTypeName, String description) throws Exception {
        if (bindingName == null || portTypeName == null) {
            throw new VWException("filenet.ws.api.bindingNameOrPortTypeNameNull", "addBinding({0}, {1}): binding name or port type name is null", bindingName, portTypeName);
        }
        QName qname = new QName(this.m_definitionTNS, bindingName);
        Binding binding = this.m_definition.getBinding(qname);
        PortType portType = null;
        if (binding != null) {
            throw new VWException("filenet.ws.api.bindingWIthSameNameAlreadyAdded", "addBinding({0}, {1}): binding with the same name already added", bindingName, portTypeName);
        }
        portType = this.m_definition.getPortType(new QName(this.m_definitionTNS, portTypeName));
        if (portType == null) {
            portType = this.addPortType(portTypeName, null);
        }
        binding = this.m_definition.createBinding();
        binding.setQName(qname);
        binding.setPortType(portType);
        binding.setUndefined(false);
        if (description != null) {
            Element docElt = this.createDescriptionElement(description);
            binding.setDocumentationElement(docElt);
        }
        SOAPBinding soapBinding = (SOAPBinding)this.m_definition.getExtensionRegistry().createExtension(Binding.class, WSSOAPConstants.Q_ELEM_SOAP_BINDING);
        soapBinding.setStyle("document");
        soapBinding.setTransportURI(s_soapHttpTransportURI);
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        this.addBindingOperations(binding, portType);
        this.m_definition.addBinding(binding);
        return binding;
    }

    public String definitionToString() throws Exception {
        return WSDefinition.definitionToString(this.m_definition);
    }

    public Binding getBinding(String bindingName) {
        if (bindingName == null) {
            return null;
        }
        QName qname = new QName(this.m_definitionTNS, bindingName);
        return this.m_definition.getBinding(qname);
    }

    private BindingInput getBindingInput(String bindingName, String operationName) throws Exception {
        Binding binding = this.m_definition.getBinding(new QName(this.m_definitionTNS, bindingName));
        if (binding == null) {
            return null;
        }
        BindingOperation bindingOperation = this.getBindingOperation(bindingName, operationName);
        if (bindingOperation == null) {
            return null;
        }
        PortType portType = binding.getPortType();
        if (portType == null) {
            return null;
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            return null;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput == null && operation.getInput() != null) {
            bindingInput = this.addBindingInput(bindingOperation, operation.getInput());
        }
        return bindingInput;
    }

    public BindingOperation getBindingOperation(String bindingName, String operationName) throws Exception {
        if (bindingName == null || operationName == null) {
            return null;
        }
        Binding binding = this.m_definition.getBinding(new QName(this.m_definition.getTargetNamespace(), bindingName));
        if (binding == null) {
            return null;
        }
        return binding.getBindingOperation(operationName, null, null);
    }

    public Definition getDefinition() {
        return this.m_definition;
    }

    public WSDefinition getWSDefinition() throws Exception {
        if (this.m_wsDefinition == null && this.m_definition != null) {
            return new WSDefinition(this.m_definition);
        }
        return null;
    }

    public Document getDocument() throws Exception {
        if (this.m_definition != null) {
            return WSDefinition.getDocument(this.m_definition);
        }
        return null;
    }

    public Operation getOperation(String portTypeName, String operationName) {
        if (portTypeName == null || operationName == null) {
            return null;
        }
        PortType portType = this.getPortType(portTypeName);
        if (portType != null) {
            return portType.getOperation(portTypeName, null, null);
        }
        return null;
    }

    public Port getPort(String serviceName, String portName) {
        if (serviceName == null || portName == null) {
            return null;
        }
        Service service = this.getService(serviceName);
        if (service != null) {
            return service.getPort(portName);
        }
        return null;
    }

    public PortType getPortType(String portTypeName) {
        if (portTypeName == null) {
            return null;
        }
        return this.m_definition.getPortType(new QName(this.m_definitionTNS, portTypeName));
    }

    public Service getService(String serviceName) {
        if (serviceName != null) {
            return this.m_definition.getService(new QName(this.m_definitionTNS, serviceName));
        }
        return null;
    }

    String[] getElementNames(String schemaName) {
        Object obj;
        if (this.m_schemas != null && schemaName != null && schemaName.length() > 0 && (obj = this.m_schemas.get(schemaName)) != null && obj instanceof Schema) {
            return ((Schema)obj).getElementNames();
        }
        return null;
    }

    public static Document xmlToDocument(String xml) throws Exception {
        if (xml == null) {
            return null;
        }
        StringReader stringReader = new StringReader(xml);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(stringReader));
        return doc;
    }

    private boolean anyProcessAttachments(QName qname) throws Exception {
        if (this.m_predefinedSchema == null) {
            return false;
        }
        return this.getPredefinedSchema().anyProcessAttachments(qname);
    }

    private BindingInput addBindingInput(BindingOperation bindingOperation, Input input) throws Exception {
        Collection parts;
        Iterator it;
        Map map;
        Message msg;
        if (bindingOperation == null) {
            return null;
        }
        boolean bSoapBodyAdded = false;
        BindingInput bindingInput = this.m_definition.createBindingInput();
        if (input != null && (msg = input.getMessage()) != null && (map = msg.getParts()) != null && map.size() > 0 && (it = (parts = map.values()).iterator()) != null) {
            Object obj = null;
            Part part = null;
            String partName = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof Part) || !this.anyProcessAttachments((part = (Part)obj).getElementName())) continue;
                this.addMimeSoapBody(bindingInput);
                bSoapBodyAdded = true;
                partName = part.getName();
                this.addMimeAttachment(input, bindingInput);
            }
        }
        if (!bSoapBodyAdded) {
            SOAPBody soapBody = (SOAPBody)this.m_definition.getExtensionRegistry().createExtension(BindingInput.class, WSSOAPConstants.Q_ELEM_SOAP_BODY);
            soapBody.setUse(s_literal);
            bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        }
        bindingOperation.setBindingInput(bindingInput);
        return bindingInput;
    }

    private BindingOperation addBindingOperation(Binding binding, Operation operation, String soapActionURI) throws Exception {
        if (binding == null || operation == null) {
            return null;
        }
        BindingOperation bindingOperation = binding.getBindingOperation(operation.getName(), null, null);
        if (bindingOperation == null) {
            bindingOperation = this.m_definition.createBindingOperation();
            bindingOperation.setName(operation.getName());
            binding.addBindingOperation(bindingOperation);
        }
        this.initBindingOperation(bindingOperation, operation, soapActionURI);
        return bindingOperation;
    }

    private void addBindingOperations(Binding binding, PortType portType) throws Exception {
        if (binding == null || portType == null) {
            return;
        }
        List pList = portType.getOperations();
        Iterator pOps = pList.iterator();
        List bList = binding.getBindingOperations();
        Iterator bOps = null;
        Object obj = null;
        Operation operation = null;
        BindingOperation bindingOperation = null;
        String opName = null;
        while (pOps.hasNext()) {
            boolean bFound = false;
            obj = pOps.next();
            if (obj != null && obj instanceof Operation) {
                operation = obj;
                opName = operation.getName();
                bOps = bList.iterator();
                if (opName != null) {
                    while (bOps.hasNext()) {
                        obj = bOps.next();
                        if (obj == null || !(obj instanceof BindingOperation) || (bindingOperation = (BindingOperation)obj).getName() == null || opName.compareTo(bindingOperation.getName()) != 0) continue;
                        bFound = true;
                        break;
                    }
                }
            }
            if (bFound) continue;
            this.addBindingOperation(binding, operation, null);
        }
    }

    private BindingOutput addBindingOutput(BindingOperation bindingOperation, Output output) throws Exception {
        Collection parts;
        Iterator it;
        Map map;
        Message msg;
        if (bindingOperation == null) {
            return null;
        }
        boolean bSoapBodyAdded = false;
        BindingOutput bindingOutput = this.m_definition.createBindingOutput();
        bindingOperation.setBindingOutput(bindingOutput);
        if (output != null && (msg = output.getMessage()) != null && (map = msg.getParts()) != null && map.size() > 0 && (it = (parts = map.values()).iterator()) != null) {
            Object obj = null;
            Part part = null;
            String partName = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof Part) || !this.anyProcessAttachments((part = (Part)obj).getElementName())) continue;
                this.addMimeSoapBody(bindingOutput);
                bSoapBodyAdded = true;
                partName = part.getName();
                this.addMimeAttachment(output, bindingOutput);
            }
        }
        if (!bSoapBodyAdded) {
            SOAPBody soapBody = (SOAPBody)this.m_definition.getExtensionRegistry().createExtension(BindingOutput.class, WSSOAPConstants.Q_ELEM_SOAP_BODY);
            soapBody.setUse(s_literal);
            bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
        }
        return bindingOutput;
    }

    private Definition createDefinition(String name, String targetNamespace, String descriptions) throws Exception {
        this.m_definitionTNS = targetNamespace;
        this.m_productInfoString = name;
        if (targetNamespace == null) {
            this.m_definitionTNS = s_targetNamespaceURI;
            if (this.m_productInfoString != null) {
                this.m_definitionTNS = this.m_definitionTNS + "/" + this.m_productInfoString;
            }
        }
        this.m_wsdlFactory = WSDLFactory.newInstance();
        Definition definition = this.m_wsdlFactory.newDefinition();
        definition.setTargetNamespace(this.m_definitionTNS);
        definition.addNamespace(s_tns, this.m_definitionTNS);
        definition.addNamespace(s_xsd, "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace(s_soap, "http://schemas.xmlsoap.org/wsdl/soap/");
        definition.addNamespace(s_wsa, "http://schemas.xmlsoap.org/ws/2003/03/addressing");
        definition.addNamespace(s_wsse, "http://schemas.xmlsoap.org/ws/2002/12/secext");
        definition.setTypes(definition.createTypes());
        if (descriptions != null) {
            definition.setDocumentationElement(this.createDescriptionElement(descriptions));
        }
        return definition;
    }

    private Element createDescriptionElement(String description) {
        return this.createDescriptionElement(null, description);
    }

    private Element createDescriptionElement(String prefix, String description) {
        Element docElt = null;
        docElt = this.m_doc.createElement("wsdl:documentation");
        Text textNode = this.m_doc.createTextNode(description);
        docElt.appendChild(textNode);
        return docElt;
    }

    private Element createElement(String name) {
        return this.m_doc.createElement(name);
    }

    private Element createElementNS(String uri, String name) {
        return this.m_doc.createElementNS(uri, name);
    }

    private Binding[] getBindings(String portTypeName) {
        Iterator it;
        if (portTypeName != null && (it = this.m_definition.getBindings().values().iterator()) != null) {
            Object obj = null;
            Vector<Binding> v = new Vector<Binding>();
            Binding binding = null;
            Object name = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof Binding) || !(binding = (Binding)obj).getPortType().getQName().equals(new QName(this.m_definitionTNS, portTypeName))) continue;
                v.add(binding);
            }
            if (v.size() > 0) {
                Binding[] bindings = new Binding[v.size()];
                v.toArray(bindings);
                v.removeAllElements();
                return bindings;
            }
        }
        return null;
    }

    private PredefinedSchema getPredefinedSchema() throws Exception {
        if (this.m_predefinedSchema == null) {
            this.m_predefinedSchema = new PredefinedSchema();
        }
        return this.m_predefinedSchema;
    }

    private QName getBaseTypeElement(String type) throws Exception {
        if (type != null) {
            return this.getPredefinedSchema().getBaseTypeElement(type);
        }
        return null;
    }

    private boolean anyProcessAttachments(Part part) throws Exception {
        if (part != null) {
            return this.getPredefinedSchema().anyProcessAttachments(part.getElementName());
        }
        return false;
    }

    private void initBindingOperation(BindingOperation bindingOperation, Operation operation, String soapActionURI) throws Exception {
        Iterator faults;
        BindingOutput bindingOutput;
        Output output;
        BindingInput bindingInput;
        this.addSoapAction(bindingOperation, soapActionURI);
        Input input = operation.getInput();
        if (input != null && (bindingInput = bindingOperation.getBindingInput()) == null) {
            bindingInput = this.addBindingInput(bindingOperation, input);
        }
        if ((output = operation.getOutput()) != null && (bindingOutput = bindingOperation.getBindingOutput()) == null) {
            bindingOutput = this.addBindingOutput(bindingOperation, output);
        }
        if ((faults = operation.getFaults().values().iterator()) != null) {
            Object obj = null;
            Fault fault = null;
            String faultName = null;
            BindingFault bindingFault = null;
            Map bindingFaults = bindingOperation.getBindingFaults();
            while (faults.hasNext()) {
                obj = faults.next();
                if (obj == null || !(obj instanceof Fault) || (faultName = (fault = (Fault)obj).getName()) == null || bindingFaults.get(fault.getName()) != null) continue;
                bindingFault = this.m_definition.createBindingFault();
                bindingFault.setName(faultName);
                SOAPFault soapFault = (SOAPFault)this.m_definition.getExtensionRegistry().createExtension(BindingFault.class, WSSOAPConstants.Q_ELEM_SOAP_FAULT);
                soapFault.setName(faultName);
                soapFault.setUse(s_literal);
                Vector<String> encodingStyles = new Vector<String>();
                encodingStyles.add(s_soapEncodingStypeURI);
                soapFault.setEncodingStyles(encodingStyles);
                bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
                bindingOperation.addBindingFault(bindingFault);
            }
        }
    }

    static {
        m_classNames.put("String", "string");
        m_classNames.put("Integer", "integer");
        m_classNames.put("Float", "float");
        m_classNames.put("Double", "double");
        m_classNames.put("Boolean", "boolean");
        m_classNames.put("Date", "dateTime");
        m_classNames.put("xmlString", "xmlString");
        m_classNames.put("attachment", "attachment");
        m_classNames.put("attachmentRef", "attachmentRef");
        m_classNames.put("String[]", "string[]");
        m_classNames.put("Integer[]", "integer[]");
        m_classNames.put("Float[]", "float[]");
        m_classNames.put("Double[]", "double[]");
        m_classNames.put("Boolean[]", "boolean[]");
        m_classNames.put("Date[]", "dateTime[]");
        m_classNames.put("xmlString[]", "xmlString[]");
        m_classNames.put("attachment[]", "attachment[]");
        m_classNames.put("attachmentRef[]", "attachmentRef[]");
    }

    class PredefinedSchema {
        Hashtable m_qnames = new Hashtable();
        Hashtable m_fieldTypes = new Hashtable();
        Hashtable m_fieldElements = new Hashtable();
        Hashtable m_fieldElementsReverse = new Hashtable();
        Hashtable m_namespaces = new Hashtable();
        Element m_schema = null;
        String m_schemaTNS = null;

        public PredefinedSchema() throws Exception {
            WSDefinitionBuilder.this.addPredefinedSchema();
            this.createSchema();
        }

        void createSchema() throws Exception {
            if (this.m_schema == null) {
                this.m_schema = WSDefinitionBuilder.this.m_doc.createElement("xsd:schema");
                if (WSDefinitionBuilder.this.m_productInfoString != null) {
                    this.m_schemaTNS = ((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_SCHEMA_PREFIX + WSDefinitionBuilder.this.m_productInfoString;
                    Element importNode = WSDefinitionBuilder.this.m_doc.createElement("xsd:import");
                    importNode.setAttribute("namespace", ((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC);
                    this.m_schema.appendChild(importNode);
                } else {
                    this.m_schemaTNS = WSDefinitionBuilder.this.m_definitionTNS + "/" + "FileNet";
                }
                this.m_schema.setAttribute("elementFormDefault", "qualified");
                this.m_schema.setAttribute(WSDefinitionBuilder.s_targetNamespace, this.m_schemaTNS);
                this.addNamespace(WSDefinitionBuilder.s_xsd, "http://www.w3.org/2001/XMLSchema");
                this.addNamespace(WSDefinitionBuilder.s_xsd0, ((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC);
                this.addNamespace(WSDefinitionBuilder.s_tns, this.m_schemaTNS);
                this.addNamespace(WSDefinitionBuilder.s_wsa, "http://schemas.xmlsoap.org/ws/2003/03/addressing");
                this.m_qnames.put("string", new QName("http://www.w3.org/2001/XMLSchema", "string"));
                this.m_qnames.put("integer", new QName("http://www.w3.org/2001/XMLSchema", "int"));
                this.m_qnames.put("boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
                this.m_qnames.put("float", new QName("http://www.w3.org/2001/XMLSchema", "double"));
                this.m_qnames.put("double", new QName("http://www.w3.org/2001/XMLSchema", "double"));
                this.m_qnames.put("dateTime", new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
                this.m_qnames.put(WSDefinitionBuilder.s_xmlStringTypeNameVersion0, new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, WSDefinitionBuilder.s_xmlStringElement));
                this.m_qnames.put("xmlString", new QName("http://www.w3.org/2001/XMLSchema", "string"));
                this.m_qnames.put("attachment", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
                this.m_qnames.put(WSDefinitionBuilder.s_attachmentByRefTypeNameVersion0, new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, WSDefinitionBuilder.s_attachmentRefElement));
                this.m_qnames.put("attachmentRef", new QName("http://www.w3.org/2001/XMLSchema", "string"));
                this.m_qnames.put("stringElement", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "stringElement"));
                this.m_qnames.put("stringArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "stringArray"));
                this.m_qnames.put("integerArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "integerArray"));
                this.m_qnames.put("booleanArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "booleanArray"));
                this.m_qnames.put("floatArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "floatArray"));
                this.m_qnames.put("doubleArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "doubleArray"));
                this.m_qnames.put("dateTimeArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "dateTimeArray"));
                this.m_qnames.put("xmlStringArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "xmlStringArray"));
                this.m_qnames.put("attachmentArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "attachmentArray"));
                this.m_qnames.put("attachmentRefArray", new QName(((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_GENERIC, "attachmentRefArray"));
                this.addSchema();
            }
        }

        private String addNamespace(String prefix, String namespace) {
            if (this.m_schema == null) {
                return null;
            }
            Object obj = this.m_namespaces.get(namespace);
            if (obj != null && obj instanceof String) {
                return (String)obj;
            }
            this.m_schema.setAttribute(WSDefinitionBuilder.s_xmlns + prefix, namespace);
            this.m_namespaces.put(namespace, prefix);
            return prefix;
        }

        String getNamespacePrefix(String namespace) {
            Object obj = this.m_namespaces.get(namespace);
            if (obj != null && obj instanceof String) {
                return (String)obj;
            }
            return null;
        }

        QName getElement(String elementName, Vector fields) throws Exception {
            if (this.m_schema == null) {
                this.createSchema();
            }
            QName qname = null;
            if (fields != null && fields.size() > 0) {
                String type = null;
                Object[] field = null;
                Object aField = null;
                Object obj = null;
                String typeName = null;
                if (elementName != null & this.m_fieldElements != null && (obj = this.m_fieldElements.get(elementName)) != null && obj instanceof QName) {
                    return obj;
                }
                String typeKey = new String();
                for (int i = 0; i < fields.size(); ++i) {
                    Object typeObj;
                    obj = fields.get(i);
                    if (obj == null || !(obj instanceof Object[]) || (field = (Object[])obj).length != 2) continue;
                    if (field[0] != null && field[0] instanceof String) {
                        typeKey = typeKey + (String)field[0];
                    }
                    if ((type = this.getTypeStringFromObject(typeObj = field[1])) == null) continue;
                    typeKey = typeKey + this.getTypeName(type);
                }
                QName typeQName = (QName)this.m_fieldTypes.get(typeKey);
                if (typeQName != null) {
                    typeName = typeQName.getLocalPart();
                }
                if (typeQName == null) {
                    typeName = elementName + WSDefinitionBuilder.s_type + this.m_fieldTypes.size();
                    Element complexTypeElt = WSDefinitionBuilder.this.m_doc.createElement("xsd:complexType");
                    complexTypeElt.setAttribute("name", typeName);
                    Element seqElt = WSDefinitionBuilder.this.m_doc.createElement("xsd:sequence");
                    String elmentDeclName = null;
                    for (int i = 0; i < fields.size(); ++i) {
                        obj = fields.get(i);
                        if (obj == null || !(obj instanceof Object[]) || (field = (Object[])obj).length != 2 || field[1] == null) continue;
                        type = this.getTypeStringFromObject(field[1]);
                        typeQName = null;
                        typeQName = this.getType(type);
                        Element elt = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                        elmentDeclName = (String)field[0];
                        elt.setAttribute("name", elmentDeclName);
                        seqElt.appendChild(elt);
                        if (WSDefinitionBuilder.this.m_wsConstants.getWSDLVersion() == 0) {
                            if ((this.isXmlStringType(type) || this.isAttachmentRefType(type)) && !this.isArray(type)) {
                                QName version0typeQName = this.getType(type + WSDefinitionBuilder.s_version0);
                                elt.setAttribute("ref", this.getNamespacePrefix(version0typeQName.getNamespaceURI()) + ":" + version0typeQName.getLocalPart());
                                continue;
                            }
                            elt.setAttribute("type", this.getNamespacePrefix(typeQName.getNamespaceURI()) + ":" + typeQName.getLocalPart());
                            continue;
                        }
                        elt.setAttribute("type", this.getNamespacePrefix(typeQName.getNamespaceURI()) + ":" + typeQName.getLocalPart());
                        if (!this.isXmlStringType(type) && !this.isAttachmentRefType(type) || this.isArray(type)) continue;
                        Element annotation = WSDefinitionBuilder.this.m_doc.createElement("xsd:annotation");
                        Element appInfo = WSDefinitionBuilder.this.m_doc.createElement("xsd:appinfo");
                        annotation.appendChild(appInfo);
                        Element processType = WSDefinitionBuilder.this.m_doc.createElement("tns:processType");
                        processType.setAttribute("name", type);
                        appInfo.appendChild(processType);
                        elt.appendChild(annotation);
                    }
                    complexTypeElt.appendChild(seqElt);
                    this.m_schema.appendChild(complexTypeElt);
                    typeQName = new QName(this.m_schemaTNS, typeName);
                    this.m_fieldTypes.put(typeKey, typeQName);
                    this.m_qnames.put(typeKey, typeQName);
                }
                Element element = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                element.setAttribute("name", elementName);
                element.setAttribute("type", "tns:" + typeName);
                this.m_schema.appendChild(element);
                qname = new QName(this.m_schemaTNS, elementName);
                this.m_qnames.put(elementName, qname);
                this.m_fieldElements.put(elementName, qname);
                this.m_fieldElementsReverse.put(qname, elementName);
            }
            return qname;
        }

        QName getElement(String prefix, String prefix1, Vector fields) throws Exception {
            int nFields;
            if (this.m_schema == null) {
                this.createSchema();
            }
            QName qname = null;
            int n = nFields = fields == null ? 0 : fields.size();
            if (nFields > 0) {
                String type = null;
                Object[] field = null;
                Object aField = null;
                Object obj = null;
                String elementName = prefix + prefix1 + WSDefinitionBuilder.s_element;
                String typeName = null;
                if (elementName != null && this.m_fieldElements != null && (obj = this.m_fieldElements.get(elementName)) != null && obj instanceof QName) {
                    return obj;
                }
                String typeKey = "";
                for (int i = 0; i < nFields; ++i) {
                    Object typeObj;
                    obj = fields.get(i);
                    if (obj == null || !(obj instanceof Object[]) || (field = (Object[])obj).length != 2) continue;
                    if (field[0] != null && field[0] instanceof String) {
                        typeKey = typeKey + (String)field[0];
                    }
                    if ((type = this.getTypeStringFromObject(typeObj = field[1])) == null) continue;
                    typeKey = typeKey + this.getTypeName(type);
                }
                QName typeQName = (QName)this.m_fieldTypes.get(typeKey);
                if (typeQName != null) {
                    typeName = typeQName.getLocalPart();
                }
                if (typeQName == null) {
                    typeName = prefix1 + WSDefinitionBuilder.s_type + this.m_fieldTypes.size();
                    Element complexTypeElt = WSDefinitionBuilder.this.m_doc.createElement("xsd:complexType");
                    complexTypeElt.setAttribute("name", typeName);
                    Element seqElt = WSDefinitionBuilder.this.m_doc.createElement("xsd:sequence");
                    String elmentDeclName = null;
                    boolean bAttachmentRef = false;
                    boolean bXmlString = false;
                    for (int i = 0; i < fields.size(); ++i) {
                        obj = fields.get(i);
                        if (obj == null || !(obj instanceof Object[]) || (field = (Object[])obj).length != 2 || field[1] == null) continue;
                        type = this.getTypeStringFromObject(field[1]);
                        typeQName = null;
                        typeQName = this.getType(type);
                        Element elt = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                        elmentDeclName = (String)field[0];
                        elt.setAttribute("name", elmentDeclName);
                        if ((this.isXmlStringType(type) || this.isAttachmentRefType(type)) && !this.isArray(type)) {
                            elt.setAttribute("ref", this.getNamespacePrefix(typeQName.getNamespaceURI()) + ":" + typeQName.getLocalPart());
                        } else {
                            elt.setAttribute("type", this.getNamespacePrefix(typeQName.getNamespaceURI()) + ":" + typeQName.getLocalPart());
                        }
                        seqElt.appendChild(elt);
                    }
                    complexTypeElt.appendChild(seqElt);
                    this.m_schema.appendChild(complexTypeElt);
                    typeQName = new QName(this.m_schemaTNS, typeName);
                    this.m_fieldTypes.put(typeKey, typeQName);
                    this.m_qnames.put(typeKey, typeQName);
                }
                Element element = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                element.setAttribute("name", elementName);
                element.setAttribute("type", "tns:" + typeName);
                this.m_schema.appendChild(element);
                qname = new QName(this.m_schemaTNS, elementName);
                this.m_qnames.put(elementName, qname);
                this.m_fieldElements.put(elementName, qname);
                this.m_fieldElementsReverse.put(qname, elementName);
            }
            return qname;
        }

        QName getAttachmentElement(Object obj) throws Exception {
            Object[] attachmentField;
            if (this.m_schema == null) {
                this.createSchema();
            }
            if (obj != null && obj instanceof Object[] && ((Object[])obj).length == 2 && (attachmentField = (Object[])obj)[1] instanceof String) {
                String type = (String)attachmentField[1];
                if (type.endsWith("[]")) {
                    return this.getMimeArrayElement();
                }
                return this.getMimeElement();
            }
            return null;
        }

        QName[] getElements(String prefix, Vector fields, boolean bAttachment) throws Exception {
            if (fields != null && fields.size() > 0) {
                if (this.m_schema == null) {
                    this.createSchema();
                }
                String prefix1 = bAttachment ? WSDefinitionBuilder.s_processAttachment : WSDefinitionBuilder.s_processField;
                QName[] elements = new QName[fields.size()];
                Object element = null;
                Vector v = new Vector();
                for (int i = 0; i < fields.size(); ++i) {
                    v.removeAllElements();
                    v.add(fields.get(i));
                    elements[i] = this.getElement(prefix, prefix1 + i, v);
                }
                return elements;
            }
            return null;
        }

        QName getElement(String prefix, Vector fields, boolean bAttachment) throws Exception {
            if (fields != null && fields.size() > 0) {
                if (this.m_schema == null) {
                    this.createSchema();
                }
                String prefix1 = bAttachment ? WSDefinitionBuilder.s_processAttachment : WSDefinitionBuilder.s_processField;
                return this.getElement(prefix + prefix1 + WSDefinitionBuilder.s_element, fields);
            }
            return null;
        }

        private String getTypeStringFromObject(Object typeObj) throws Exception {
            if (this.m_schema == null) {
                this.createSchema();
            }
            String typeString = null;
            if (typeObj != null) {
                String className = null;
                if (typeObj instanceof Class) {
                    Class cls = (Class)typeObj;
                    String pkg = null;
                    if (cls.isArray()) {
                        className = cls.getComponentType().getName() + "[]";
                        pkg = cls.getComponentType().getPackage().getName();
                    } else {
                        className = cls.getName();
                        pkg = cls.getPackage().getName();
                    }
                    int index = className.indexOf(pkg);
                    if (index != -1) {
                        className = className.substring(index + pkg.length() + 1, className.length());
                    }
                } else if (typeObj instanceof String) {
                    className = (String)typeObj;
                }
                if (className != null) {
                    typeString = (String)m_classNames.get(className);
                }
            }
            return typeString;
        }

        private boolean isArrayType(Object typeObj) {
            if (typeObj != null) {
                Object className = null;
                if (typeObj instanceof Class) {
                    Class cls = (Class)typeObj;
                    return cls.isArray();
                }
            }
            return false;
        }

        private boolean isAttachmentRefType(String type) {
            if (type != null) {
                return type.startsWith("attachmentRef");
            }
            return false;
        }

        private boolean isXmlStringType(String type) {
            if (type != null) {
                return type.startsWith("xmlString");
            }
            return false;
        }

        QName getType(String type) throws Exception {
            String typeName;
            Object obj;
            if (this.m_schema == null) {
                this.createSchema();
            }
            if ((obj = this.m_qnames.get(typeName = this.getTypeName(type))) != null && obj instanceof QName) {
                return (QName)obj;
            }
            QName qname = null;
            if (this.isArray(type)) {
                Element complexTypeElt = WSDefinitionBuilder.this.m_doc.createElement("xsd:complexType");
                complexTypeElt.setAttribute("name", typeName);
                Element seqElt = WSDefinitionBuilder.this.m_doc.createElement("xsd:sequence");
                Element elt = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                String simpleTypeName = this.getSimpleTypeName(type);
                elt.setAttribute("maxOccurs", "unbounded");
                elt.setAttribute("minOccurs", "0");
                elt.setAttribute("nillable", "true");
                elt.setAttribute("name", simpleTypeName);
                elt.setAttribute("type", "xsd:" + simpleTypeName);
                seqElt.appendChild(elt);
                complexTypeElt.appendChild(seqElt);
                this.m_schema.appendChild(complexTypeElt);
                qname = new QName(this.m_schemaTNS, typeName);
                this.m_qnames.put(typeName, new QName(this.m_schemaTNS, typeName));
            } else {
                qname = new QName("http://www.w3.org/2001/XMLSchema", typeName);
                this.m_qnames.put(typeName, qname);
            }
            return qname;
        }

        QName getArray(String type) throws Exception {
            if (type == null) {
                return null;
            }
            if (this.m_schema == null) {
                this.createSchema();
            }
            String typeName = this.getTypeName(type);
            String arrayElementName = this.getElementName(type);
            if (type == null) {
                return null;
            }
            Object obj = this.m_qnames.get(arrayElementName);
            QName qname = null;
            if (obj != null && obj instanceof QName) {
                qname = (QName)obj;
            } else {
                QName typeQName = this.getType(type);
                Element element = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                element.setAttribute("name", arrayElementName);
                element.setAttribute("type", this.getNamespacePrefix(typeQName.getNamespaceURI()) + ":" + typeQName.getLocalPart());
                this.m_schema.appendChild(element);
                qname = new QName(this.m_schemaTNS, arrayElementName);
                this.m_qnames.put(arrayElementName, qname);
            }
            return qname;
        }

        String getSimpleTypeName(String type) {
            int index = type.indexOf("[]");
            if (index != -1) {
                type = type.substring(0, index);
            }
            return type;
        }

        boolean isArray(String type) {
            if (type != null) {
                return type.indexOf("[]") != -1;
            }
            return false;
        }

        QName getBaseTypeElement(String type) throws Exception {
            if (this.isArray(type)) {
                return this.getArray(type);
            }
            return this.getSimpleTypeElement(type);
        }

        String getTypeName(String type) {
            if (this.isArray(type)) {
                return this.getSimpleTypeName(type) + "Array";
            }
            return type;
        }

        String getElementName(String type) {
            String typeName = this.getTypeName(type);
            if (typeName != null) {
                return typeName + WSDefinitionBuilder.s_element;
            }
            return null;
        }

        QName getBaseType(String type) throws Exception {
            String typeName = this.getSimpleTypeName(type);
            if (this.isArray(type)) {
                return this.getArray(type);
            }
            return this.getSimpleTypeElement(type);
        }

        QName getSimpleTypeElement(String typeName) throws Exception {
            if (this.m_schema == null) {
                this.createSchema();
            }
            String elementName = typeName + WSDefinitionBuilder.s_element;
            Object obj = this.m_qnames.get(elementName);
            QName qname = null;
            if (obj == null) {
                Element element = WSDefinitionBuilder.this.m_doc.createElement("xsd:element");
                element.setAttribute("name", elementName);
                element.setAttribute("type", "xsd:" + typeName);
                this.m_schema.appendChild(element);
                qname = new QName(this.m_schemaTNS, elementName);
                this.m_qnames.put(elementName, qname);
            } else if (obj instanceof QName) {
                qname = (QName)obj;
            }
            return qname;
        }

        QName getMimeArrayElement() throws Exception {
            this.addNamespace(WSDefinitionBuilder.s_wsa, "http://schemas.xmlsoap.org/ws/2003/03/addressing");
            return this.getArray("attachment[]");
        }

        QName getMimeElement() throws Exception {
            this.addNamespace(WSDefinitionBuilder.s_wsa, "http://schemas.xmlsoap.org/ws/2003/03/addressing");
            return this.getSimpleTypeElement("attachment");
        }

        boolean anyProcessAttachments(QName elementName) {
            String obj;
            return elementName != null && (obj = (String)this.m_fieldElementsReverse.get(elementName)) != null && obj instanceof String && obj.indexOf(WSDefinitionBuilder.s_processAttachment) != -1;
        }

        private void addSchema() throws Exception {
            if (this.m_schema != null) {
                WSDefinitionBuilder.this.m_definition.addNamespace(WSDefinitionBuilder.s_xsd0, this.m_schemaTNS);
                Types types = WSDefinitionBuilder.this.m_definition.getTypes();
                javax.wsdl.extensions.schema.Schema schemaImpl = (javax.wsdl.extensions.schema.Schema)WSDefinitionBuilder.this.m_definition.getExtensionRegistry().createExtension(Types.class, new QName(WSDefinitionBuilder.this.m_definition.getNamespace(WSDefinitionBuilder.s_xsd), WSDefinitionBuilder.s_schema));
                schemaImpl.setElement(this.m_schema);
                types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
            }
        }
    }

    class Schema {
        Document m_doc = null;
        String m_schemaName = null;
        String m_schemaString = null;
        String m_schemaTNS = null;
        String m_schemaTNSPrefix = null;
        Element m_schema = null;
        Hashtable m_elements = new Hashtable();
        Hashtable m_types = new Hashtable();

        public void releaseReferences() {
            block4: {
                try {
                    this.m_doc = null;
                    this.m_schemaName = null;
                    this.m_schemaString = null;
                    this.m_schemaTNS = null;
                    this.m_schemaTNSPrefix = null;
                    this.m_schema = null;
                    if (this.m_elements != null) {
                        this.m_elements.clear();
                        this.m_elements = null;
                    }
                    if (this.m_types != null) {
                        this.m_types.clear();
                        this.m_types = null;
                    }
                }
                catch (Exception ex) {
                    if (!logger.isFinest()) break block4;
                    logger.throwing("WSDefinitionBuilder.Schema", "releaseReferences", ex);
                }
            }
        }

        public Schema(Element schema) {
            this.m_schema = schema;
        }

        public Schema(String schemaName, String schema) throws Exception {
            this(schemaName, schema, true);
        }

        public Schema(String schemaName, String schema, boolean bReserveOriginalTNS) throws Exception {
            this.m_schemaName = schemaName;
            this.m_schemaString = schema;
            this.addSchema(bReserveOriginalTNS);
        }

        private void addSchema(boolean bReserveOriginalTNS) throws Exception {
            this.m_doc = WSDefinitionBuilder.xmlToDocument(this.m_schemaString);
            if (this.m_doc == null) {
                return;
            }
            this.m_schema = this.m_doc.getDocumentElement();
            if (this.m_schema != null) {
                int i;
                String nodeName = this.m_schema.getNodeName();
                if (!bReserveOriginalTNS) {
                    this.m_schemaTNS = ((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_SCHEMA_PREFIX + "/" + this.m_schemaName;
                }
                String oldTargetNamespace = null;
                if (nodeName != null && nodeName.indexOf(WSDefinitionBuilder.s_schema) != -1) {
                    if (this.m_schema.getAttribute("elementFormDefault") != null) {
                        this.m_schema.removeAttribute("elementFormDefault");
                    }
                    this.m_schema.setAttribute("elementFormDefault", "qualified");
                    oldTargetNamespace = this.m_schema.getAttribute(WSDefinitionBuilder.s_targetNamespace);
                    if (this.m_schemaTNS == null || this.m_schemaTNS.length() == 0) {
                        this.m_schemaTNS = oldTargetNamespace != null && oldTargetNamespace.length() > 0 ? oldTargetNamespace : ((WSDefinitionBuilder)WSDefinitionBuilder.this).m_wsConstants.P8BPM_NS_SCHEMA_PREFIX + "/" + this.m_schemaName;
                    }
                    if (this.m_schemaTNS != null && this.m_schemaTNS.length() > 0) {
                        NamedNodeMap attributes;
                        String xmlns = this.m_schema.getAttribute("xmlns");
                        if (xmlns == null || xmlns.length() == 0) {
                            this.m_schema.setAttribute("xmlns", this.m_schemaTNS);
                        }
                        this.m_schema.setAttribute(WSDefinitionBuilder.s_targetNamespace, this.m_schemaTNS);
                        this.m_schema.setAttribute(WSDefinitionBuilder.s_xmlnsTNS, this.m_schemaTNS);
                        if (oldTargetNamespace != null && oldTargetNamespace.length() > 0 && oldTargetNamespace.compareTo(this.m_schemaTNS) != 0 && (attributes = this.m_schema.getAttributes()) != null) {
                            Node attrib = null;
                            String name = null;
                            String value = null;
                            for (i = 0; i < attributes.getLength(); ++i) {
                                attrib = attributes.item(i);
                                name = attrib.getNodeName();
                                value = attrib.getNodeValue();
                                if (value == null || value.compareTo(oldTargetNamespace) != 0) continue;
                                attrib.setNodeValue(this.m_schemaTNS);
                            }
                        }
                    }
                } else {
                    throw new VWException("filenet.ws.api.schemaMustBeSchemaElement", "Schema: the schema must be a schema element");
                }
                this.m_schemaTNSPrefix = WSDefinitionBuilder.s_xsd + (WSDefinitionBuilder.this.m_schemas.size() + 1);
                WSDefinitionBuilder.this.m_definition.addNamespace(this.m_schemaTNSPrefix, this.m_schemaTNS);
                Types types = WSDefinitionBuilder.this.m_definition.getTypes();
                ExtensionRegistry extRegistry = WSDefinitionBuilder.this.m_definition.getExtensionRegistry();
                javax.wsdl.extensions.schema.Schema schemaImpl = (javax.wsdl.extensions.schema.Schema)WSDefinitionBuilder.this.m_definition.getExtensionRegistry().createExtension(Types.class, new QName(WSDefinitionBuilder.this.m_definition.getNamespace(WSDefinitionBuilder.s_xsd), WSDefinitionBuilder.s_schema));
                schemaImpl.setElement(this.m_schema);
                types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
                NodeList list = this.m_schema.getChildNodes();
                if (list != null && list.getLength() > 0) {
                    Node node = null;
                    Element child = null;
                    Attr nameAttrib = null;
                    String name = null;
                    for (i = 0; i < list.getLength(); ++i) {
                        node = list.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        child = (Element)node;
                        nodeName = child.getNodeName();
                        nameAttrib = child.getAttributeNode("name");
                        if (nameAttrib == null) continue;
                        name = nameAttrib.getValue();
                        if (nodeName == null || name == null) continue;
                        if (nodeName.indexOf("element") != -1) {
                            this.m_elements.put(name, child);
                            continue;
                        }
                        if (nodeName.indexOf(WSDefinitionBuilder.s_type) == -1) continue;
                        this.m_types.put(name, child);
                    }
                }
            }
        }

        String getSchemaName() {
            return this.m_schemaName;
        }

        String getSchemaNS() {
            return this.m_schemaTNS;
        }

        String getSchemaNSPrefix() {
            return this.m_schemaTNSPrefix;
        }

        private boolean isElement(String name) {
            if (this.m_schema != null) {
                return this.m_elements.containsKey(name);
            }
            return false;
        }

        private boolean isType(String name) {
            if (this.m_schema != null) {
                return this.m_types.containsKey(name);
            }
            return false;
        }

        QName getElement(String name) {
            QName qname = null;
            if (this.isElement(name)) {
                qname = new QName(this.m_schemaTNS, name);
            } else if (this.isType(name)) {
                String elementName = name + WSDefinitionBuilder.s_element;
                Element element = this.m_doc.createElement("xsd:element");
                element.setAttribute("name", elementName);
                element.setAttribute("type", "tns:" + name);
                this.m_schema.appendChild(element);
                qname = new QName(this.m_schemaTNS, elementName);
            }
            return qname;
        }

        String[] getElementNames() {
            Set keys;
            if (this.m_elements != null && !this.m_elements.isEmpty() && (keys = this.m_elements.keySet()) != null && keys.size() > 0) {
                String[] elements = new String[keys.size()];
                keys.toArray(elements);
                return elements;
            }
            return null;
        }
    }
}

